/*******************************************************
Filename		:  org_elec_addr.sql
Release 		:  
SIR			:  
Description		:  Creates MetaData Organization Electronic Address table and related constraints and populates data.
Author			:  Suganthi Sivakumar
Date			:  6/16/2006.
Comments		:  
**********************************************************/

/******************************************************************
Create sequences for MetaData Organization Electronic Address table
*******************************************************************/
set echo on 
spool org_elec_addr.log
--drop sequence seq_md_org_eaddress;

create sequence seq_md_org_eaddress
start with 1 increment by 1 nomaxvalue nocycle cache 10;
/*******************************************************
Create MetaData Organization Address table
**********************************************************/
--drop table md_org_eaddress;

create table md_org_eaddress
( pk_isn number(12,0),
  eaddr_is_number number(12,0) not null,
  organization_id VARCHAR2(256 char) not null,
  organization_is_number number(12,0),
  address_type VARCHAR2(256 char) not null,
  address_one_text VARCHAR2(256 char) not null,
  address_two_text VARCHAR2(256 char));

alter table md_org_eaddress
add constraint pk_org_eaddr primary key (pk_isn)
using index
tablespace  STORETINDX
storage(initial 300k next 300k)
nologging;

create index ieorgid on md_org_eaddress(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;


/* moved after the insert block
alter table md_org_eaddress
add( fk_org number(12,0));

update md_org_eaddress oe
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=oe.organization_is_number)
where oe.organization_is_number is not null;
commit;

create index ieorg on md_org_eaddress(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_org_eaddress
add constraint fk_md_eorg foreign key (fk_org) references di_org(pk_isn);

commit;
*/


/****************************************************************
Populate MetaData Organization Electronic Address table with data.
*****************************************************************/

set serveroutput on
declare 
cursor c_org_eaddr is 
select distinct TSMEADDR_IS_NUMBER,TSMEADDR_ORG_ID,TYPE_CODE,ADDRESS_TEXT,COMMENT_TEXT,TSMORGAN_IS_NUMBER
from storet1.tsmeaddr EA, storetw.di_org DG
where EA.tsmorgan_is_number = DG.organization_is_number; 

begin
  for c_var in c_org_eaddr loop
    insert into md_org_eaddress
    (pk_isn,eaddr_is_number,organization_id,organization_is_number,address_type,address_one_text,address_two_text)
    values
    (seq_md_org_eaddress.nextval,c_var.tsmeaddr_is_number,c_var.tsmeaddr_org_id,c_var.tsmorgan_is_number,c_var.type_code,c_var.address_text,c_var.comment_text);
  end loop;
  commit;
end;
/
show errors;
commit;

alter table md_org_eaddress
add( fk_org number(12,0));

update md_org_eaddress oe
set fk_org =(select pk_isn from di_org o
              where o.organization_is_number=oe.organization_is_number)
where oe.organization_is_number is not null;
commit;

create index ieorg on md_org_eaddress(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table md_org_eaddress
add constraint fk_md_eorg foreign key (fk_org) references di_org(pk_isn);

commit;

alter table md_org_eaddress add SOURCE_SYSTEM VARCHAR2(256 CHAR);
alter table md_org_eaddress add SOURCE_UID NUMBER(20);
commit;

alter table md_org_eaddress modify eaddr_is_number number(12,0) null;
alter table md_org_eaddress add SOURCE_ORGPH_UID NUMBER(20);



spool off;
